using System;

class Program
{
    static void Main(string[] args)
    {
        int N = int.Parse(Console.ReadLine());
        int[] A = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
        int[] B = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

        Console.WriteLine(SolveMaxValue(N, A, B));
    }

    static long SolveMaxValue(int N, int[] A, int[] B)
    {
        int[] prefixXOR = new int[N + 1];
        for (int i = 1; i <= N; i++)
        {
            prefixXOR[i] = prefixXOR[i - 1] ^ A[i - 1];
        }

        long maxValue = 0;

        for (int L = 1; L <= N; L++)
        {
            int currentAND = B[L - 1];
            for (int R = L; R <= N; R++)
            {
                currentAND &= B[R - 1]; 
                if (currentAND == 0) break; 

                int currentXOR = prefixXOR[R] ^ prefixXOR[L - 1];

                maxValue = Math.Max(maxValue, (long)currentXOR * currentAND);
            }
        }

        return maxValue;
    }
}